/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.capability.object;

import dev.toma.gunsrpg.api.common.attribute.IAttributeId;
import dev.toma.gunsrpg.api.common.attribute.IAttributeModifier;
import dev.toma.gunsrpg.api.common.attribute.IAttributeProvider;
import dev.toma.gunsrpg.api.common.data.IPerkProvider;
import dev.toma.gunsrpg.api.common.data.IPlayerCapEntry;
import dev.toma.gunsrpg.api.common.perk.IPerkStat;
import dev.toma.gunsrpg.common.item.perk.Crystal;
import dev.toma.gunsrpg.common.item.perk.CrystalAttribute;
import dev.toma.gunsrpg.common.perk.Perk;
import dev.toma.gunsrpg.util.IIntervalProvider;
import dev.toma.gunsrpg.util.Interval;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class PlayerPerkProvider
implements IPerkProvider,
IPlayerCapEntry {
    public static final Interval USE_COOLDOWN = Interval.minutes(10);
    private final IAttributeProvider attributeProvider;
    private final Int2ObjectMap<Crystal> slot2CrystalMap = new Int2ObjectOpenHashMap();
    private final Map<Perk, PerkStat> perkData = new HashMap<Perk, PerkStat>();
    private IPlayerCapEntry.IClientSynchReq syncRequestFactory;
    private int perkPoints;
    private int cooldown;

    public PlayerPerkProvider(IAttributeProvider provider) {
        this.attributeProvider = provider;
    }

    @Override
    public void tick() {
        if (this.cooldown > 0) {
            --this.cooldown;
        }
    }

    @Override
    public Crystal getCrystal(int slot) {
        return (Crystal)this.slot2CrystalMap.get(slot);
    }

    @Override
    public void setCrystal(int slot, Crystal crystal) {
        if (crystal != null) {
            this.slot2CrystalMap.put(slot, (Object)crystal);
        } else {
            this.slot2CrystalMap.remove(slot);
        }
        this.computePerkData();
        this.syncRequestFactory.makeSyncRequest();
    }

    @Override
    public int getPoints() {
        return this.perkPoints;
    }

    @Override
    public void awardPoints(int amount) {
        this.perkPoints += amount;
        this.syncRequestFactory.makeSyncRequest();
    }

    @Override
    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
        this.syncRequestFactory.makeSyncRequest();
    }

    @Override
    public void setCooldown(IIntervalProvider provider) {
        this.setCooldown(provider.getTicks());
    }

    @Override
    public int getCooldown() {
        return this.cooldown;
    }

    @Override
    public boolean isOnCooldown() {
        return this.cooldown > 0;
    }

    @Override
    public int getFlag() {
        return 128;
    }

    @Override
    public void toNbt(CompoundNBT nbt) {
        CompoundNBT data = new CompoundNBT();
        data.func_74768_a("points", this.perkPoints);
        CompoundNBT map = new CompoundNBT();
        this.slot2CrystalMap.forEach((i, crystal) -> map.func_218657_a(i.toString(), (INBT)crystal.toNbt()));
        data.func_218657_a("crystals", (INBT)map);
        data.func_74768_a("cooldown", this.cooldown);
        nbt.func_218657_a("perks", (INBT)data);
    }

    @Override
    public void fromNbt(CompoundNBT nbt) {
        this.slot2CrystalMap.clear();
        CompoundNBT data = nbt.func_150297_b("perks", 10) ? nbt.func_74775_l("perks") : new CompoundNBT();
        this.perkPoints = data.func_74762_e("points");
        CompoundNBT map = data.func_74775_l("crystals");
        map.func_150296_c().forEach(key -> {
            CompoundNBT crystalNbt = map.func_74775_l(key);
            int index = Integer.parseInt(key);
            Crystal crystal = Crystal.fromNbt(crystalNbt);
            this.slot2CrystalMap.put(index, (Object)crystal);
        });
        this.cooldown = nbt.func_74762_e("cooldown");
        this.computePerkData();
    }

    @Override
    public void setClientSynch(IPlayerCapEntry.IClientSynchReq request) {
        this.syncRequestFactory = request;
    }

    @Override
    public Set<Perk> getActivePerks() {
        return this.perkData.keySet();
    }

    @Override
    public IPerkStat getPerkStat(Perk perk) {
        return this.perkData.get(perk);
    }

    private void computePerkData() {
        this.clearAttributes();
        HashMap<Perk, List> collectionMap = new HashMap<Perk, List>();
        for (Crystal crystal : this.slot2CrystalMap.values()) {
            if (crystal == null) continue;
            List<CrystalAttribute> attributes = crystal.listAttributes();
            for (CrystalAttribute attribute : attributes) {
                Perk perk = attribute.getPerk();
                collectionMap.computeIfAbsent(perk, key -> new ArrayList()).add(attribute);
            }
        }
        for (Map.Entry entry : collectionMap.entrySet()) {
            CrystalAttribute attribute;
            Perk perk = (Perk)entry.getKey();
            List list = (List)entry.getValue();
            if (list.isEmpty()) continue;
            attribute = CrystalAttribute.flatten(perk, list);
            IAttributeModifier modifier = attribute.getModifier();
            IAttributeId attributeId = perk.getAttributeId();
            this.attributeProvider.getAttribute(attributeId).addModifier(modifier);
            this.perkData.put(perk, new PerkStat(attribute, modifier));
        }
    }

    private void clearAttributes() {
        for (Map.Entry<Perk, PerkStat> entry : this.perkData.entrySet()) {
            IAttributeId id = entry.getKey().getAttributeId();
            this.attributeProvider.getAttribute(id).removeModifier(entry.getValue().modifier);
        }
        this.perkData.clear();
    }

    private static class PerkStat
    implements IPerkStat {
        private final CrystalAttribute attribute;
        private final IAttributeModifier modifier;

        PerkStat(CrystalAttribute attribute, IAttributeModifier modifier) {
            this.attribute = attribute;
            this.modifier = modifier;
        }

        @Override
        public CrystalAttribute getAttribute() {
            return this.attribute;
        }

        @Override
        public IAttributeModifier getModifier() {
            return this.modifier;
        }
    }
}

